-- Macro Scripts File
-- Created:  Jan 12 2004
-- Author:   Michael Russo
-- Macro Scripts for Parameter Collector
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

macroScript ParamCollectorShow
	category:~PARAMCOLLECTORSHOW_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORSHOW_TOOLTIP~
	ButtonText:~PARAMCOLLECTORSHOW_BUTTONTEXT~ 
(
	On Execute Do     
	(
		Try (
			if ParamCollectorOps.visible != undefined do ParamCollectorOps.visible = true 
		)
		Catch() 
	)

	on closeDialogs do
	(
		Try (
			if ParamCollectorOps.visible != undefined do ParamCollectorOps.visible = false 
		)
		Catch() 
	)

	on isChecked Do
	(
		if ParamCollectorOps.visible == undefined then false
		else ParamCollectorOps.visible
	)

)

macroScript ParamCollectorTrackView
	category:~PARAMCOLLECTORTRACKVIEW_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORTRACKVIEW_TOOLTIP~
	ButtonText:~PARAMCOLLECTORTRACKVIEW_BUTTONTEXT~ 
(
	On Execute Do	
	(
 		if trackviews.current != undefined do  (
 		
			if (not ParamCollectorOps.visible) do ParamCollectorOps.visible = true
			
 			--trackviews.current.updatelist()
 			local iCount = trackviews.current.numSelTracks()
 			local anims = #()
 			local subs = #()
			for i = 1 to iCount do
			(
				local anim = trackviews.current.getParentOfSelected i
				if anim != undefined do (
					local subnum = trackviews.current.getSelectedSubNum i
					append anims anim
					append subs subnum
				)
			)
			for i = 1 to anims.count do (
				ParamCollectorOps.addParameterBySubNum anims[i] subs[i] 0 0 ""			
			) 
			ParamCollectorOps.refresh()
		)
	)

	on isEnabled do
	(
		trackviews.current != undefined and trackviews.current.numSelTracks() > 0
	)
)



macroScript ParamCollectorSchematicView
	category:~PARAMCOLLECTORSCHEMATICVIEW_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORSCHEMATICVIEW_TOOLTIP~
	ButtonText:~PARAMCOLLECTORSCHEMATICVIEW_BUTTONTEXT~ 
(
	On Execute Do	
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if (not ParamCollectorOps.visible) do ParamCollectorOps.visible = true

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			for i in selList do (
				local anim = sv.getSVNodeOwner i
				local subnum = sv.getSVNodeAnimID i
				ParamCollectorOps.addParameterBySubNum anim (subnum+1) 0 0 ""
			)

			ParamCollectorOps.refresh()

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if schematicViews.current != undefined then 
		(
			local selList = schematicViews.current.getSelectedSVNodes()	
			selList.Count > 0
		)
		else
		(
			false
		)
	)
)

macroScript ParamCollectorNewCollection
	category:~PARAMCOLLECTORNEWCOLLECTION_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORNEWCOLLECTION_TOOLTIP~
	ButtonText:~PARAMCOLLECTORNEWCOLLECTION_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.NewCollection() )
		Catch() 
	)
	
	On isEnabled return (ParamCollectorOps.GetActiveCollection() > 1 )
)

macroScript ParamCollectorDuplicateCollection
	category:~PARAMCOLLECTORDUPLICATECOLLECTION_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORDUPLICATECOLLECTION_TOOLTIP~
	ButtonText:~PARAMCOLLECTORDUPLICATECOLLECTION_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.DuplicateCollection() )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.GetActiveCollection() > 1)
)

macroScript ParamCollectorDeleteCollection
	category:~PARAMCOLLECTORDELETECOLLECTION_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORDELETECOLLECTION_TOOLTIP~
	ButtonText:~PARAMCOLLECTORDELETECOLLECTION_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.DeleteCollection() )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.GetActiveCollection() > 1)
)


macroScript ParamCollectorMultiEdits
	category:~PARAMCOLLECTORMULTIEDITS_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORMULTIEDITS_TOOLTIP~
	ButtonText:~PARAMCOLLECTORMULTIEDITS_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.multiedits = not ParamCollectorOps.multiedits )
		Catch() 
	)

	on isChecked return (ParamCollectorOps.multiedits)
--	On isEnabled return (ParamCollectorOps.AnySelected())	
)

macroScript ParamCollectorAbsolute
	category:~PARAMCOLLECTORABSOLUTE_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORABSOLUTE_TOOLTIP~
	ButtonText:~PARAMCOLLECTORABSOLUTE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.isAbsolute = true )
		Catch() 
	)

	on isChecked return (ParamCollectorOps.isAbsolute)
)

macroScript ParamCollectorRelative
	category:~PARAMCOLLECTORRELATIVE_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORRELATIVE_TOOLTIP~
	ButtonText:~PARAMCOLLECTORRELATIVE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.isAbsolute = false )
		Catch() 
	)

	on isChecked return (not ParamCollectorOps.isAbsolute)
)

macroScript ParamCollectorAddToSelected
	category:~PARAMCOLLECTORADDTOSELECTED_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORADDTOSELECTED_TOOLTIP~
	ButtonText:~PARAMCOLLECTORADDTOSELECTED_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.doAddToSelectedDialog() )
		Catch() 
	)
	
	On isEnabled return (ParamCollectorOps.IsRolloutSelected())
)

macroScript ParamCollectorAdd
	category:~PARAMCOLLECTORADD_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORADD_TOOLTIP~
	ButtonText:~PARAMCOLLECTORADD_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.doAddDialog() )
		Catch() 
	)
)

macroScript ParamCollectorDeleteSelected
	category:~PARAMCOLLECTORDELETESELECTED_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORDELETESELECTED_TOOLTIP~
	ButtonText:~PARAMCOLLECTORDELETESELECTED_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.deleteSelectedParameters() )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)

macroScript ParamCollectorDeleteAll
	category:~PARAMCOLLECTORDELETEALL_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORDELETEALL_TOOLTIP~
	ButtonText:~PARAMCOLLECTORDELETEALL_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.deleteAllParameters() )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnyRollouts())
)

macroScript ParamCollectorNewRollout
	category:~PARAMCOLLECTORNEWROLLOUT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORNEWROLLOUT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORNEWROLLOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.addNewRollout "" false)
		Catch() 
	)
)

macroScript ParamCollectorNewRolloutWithSelected
	category:~PARAMCOLLECTORNEWROLLOUTWITHSELECTED_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORNEWROLLOUTWITHSELECTED_TOOLTIP~
	ButtonText:~PARAMCOLLECTORNEWROLLOUTWITHSELECTED_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.addNewRollout "" true)
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)

macroScript ParamCollectorDeleteRollout
	category:~PARAMCOLLECTORDELETEROLLOUT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORDELETEROLLOUT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORDELETEROLLOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.deleteRollout -1 )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.IsRolloutSelected())
)

macroScript ParamCollectorDeleteRolloutMoveUp
	category:~PARAMCOLLECTORDELETEROLLOUTMOVEUP_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORDELETEROLLOUTMOVEUP_TOOLTIP~
	ButtonText:~PARAMCOLLECTORDELETEROLLOUTMOVEUP_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.deleteRolloutMoveUp -1 )
		Catch() 
	)
	On isEnabled Do
	(
		if (ParamCollectorOps.IsRolloutSelected()) then 
		(
			local iRolloutIndex = ParamCollectorOps.getSelectedRollout()
			(iRolloutIndex > 1)
		)
		else
			false
	)
)

macroScript ParamCollectorDeleteRolloutMoveDown
	category:~PARAMCOLLECTORDELETEROLLOUTMOVEDOWN_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORDELETEROLLOUTMOVEDOWN_TOOLTIP~
	ButtonText:~PARAMCOLLECTORDELETEROLLOUTMOVEDOWN_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.deleteRolloutMoveDown -1 )
		Catch() 
	)
	On isEnabled Do
	(
		if (ParamCollectorOps.IsRolloutSelected()) then
		(
			local iCollection = ParamCollectorOps.GetActiveCollection()
			local iNumRollouts = ParamCollectorOps.numRollouts iCollection
			local iRolloutIndex = ParamCollectorOps.getSelectedRollout()
			(iRolloutIndex < iNumRollouts)
		)
		else
			false
	)
)

macroScript ParamCollectorPutToObject
	category:~PARAMCOLLECTORPUTTOOBJECT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORPUTTOOBJECT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORPUTTOOBJECT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.doPutToObjectDialog() )
		Catch() 
	)
)

macroScript ParamCollectorGetFromObject
	category:~PARAMCOLLECTORGETFROMOBJECT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORGETFROMOBJECT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORGETFROMOBJECT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.doGetFromObjectDialog() )
		Catch() 
	)
)

macroScript ParamCollectorRemoveFromObject
	category:~PARAMCOLLECTORREMOVEFROMOBJECT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORREMOVEFROMOBJECT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORREMOVEFROMOBJECT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.doRemoveFromObjectDialog() )
		Catch() 
	)
)

macroScript ParamCollectorLinkToObject
	category:~PARAMCOLLECTORLINKTOOBJECT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORLINKTOOBJECT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORLINKTOOBJECT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.doLinkToObjectDialog() )
		Catch() 
	)
)

macroScript ParamCollectorRemoveLinkToObject
	category:~PARAMCOLLECTORREMOVELINKTOOBJECT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORREMOVELINKTOOBJECT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORREMOVELINKTOOBJECT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.RemoveLinkToObject() )
		Catch() 
	)
)

macroScript ParamCollectorRenameRollout
	category:~PARAMCOLLECTORRENAMEROLLOUT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORRENAMEROLLOUT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORRENAMEROLLOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.doRenameRolloutDialog() )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.IsRolloutSelected())
)

macroScript ParamCollectorMoveParamsUp
	category:~PARAMCOLLECTORMOVEPARAMSUP_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORMOVEPARAMSUP_TOOLTIP~
	ButtonText:~PARAMCOLLECTORMOVEPARAMSUP_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.moveSelectedParameters #moveUp )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)

macroScript ParamCollectorMoveParamsDown
	category:~PARAMCOLLECTORMOVEPARAMSDOWN_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORMOVEPARAMSDOWN_TOOLTIP~
	ButtonText:~PARAMCOLLECTORMOVEPARAMSDOWN_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.moveSelectedParameters #moveDown )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)

macroScript ParamCollectorMoveParamsUpRollout
	category:~PARAMCOLLECTORMOVEPARAMSUPROLLOUT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORMOVEPARAMSUPROLLOUT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORMOVEPARAMSUPROLLOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.moveSelectedParameters #moveUpRollout )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)

macroScript ParamCollectorMoveParamsDownRollout
	category:~PARAMCOLLECTORMOVEPARAMSDOWNROLLOUT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORMOVEPARAMSDOWNROLLOUT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORMOVEPARAMSDOWNROLLOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.moveSelectedParameters #moveDownRollout )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)


macroScript ParamCollectorSelectAll
	category:~PARAMCOLLECTORSELECTALL_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORSELECTALL_TOOLTIP~
	ButtonText:~PARAMCOLLECTORSELECTALL_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.selectAll() )
		Catch() 
	)
	On isEnabled do 
	(
		if (ParamCollectorOps.AnyParameters()) then
		(
			local iCollection = ParamCollectorOps.getActiveCollection()
			local iNumParams = ParamCollectorOps.getNumParametersInCollection iCollection
			local iNumSel = ParamCollectorOps.numSelected()
			(iNumParams != iNumSel)
		)
		else
			false
	)
)

macroScript ParamCollectorSelectAllRollout
	category:~PARAMCOLLECTORSELECTALLROLLOUT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORSELECTALLROLLOUT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORSELECTALLROLLOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.selectAllRollout() )
		Catch() 
	)
	On isEnabled do
	(
		if (ParamCollectorOps.IsRolloutSelected()) then
		(
			local iCollection = ParamCollectorOps.getActiveCollection()
			local iSelRollout = ParamCollectorOps.getSelectedRollout()
			local iNumParams = ParamCollectorOps.getNumParameters iCollection iSelRollout
			local iNumSel = ParamCollectorOps.getNumSelectedParameters iCollection iSelRollout
			(iNumParams != iNumSel) 
		)
		else
			false
	)
)

macroScript ParamCollectorSelectNone
	category:~PARAMCOLLECTORSELECTNONE_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORSELECTNONE_TOOLTIP~
	ButtonText:~PARAMCOLLECTORSELECTNONE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.selectNone() )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)

macroScript ParamCollectorSelectInvert
	category:~PARAMCOLLECTORSELECTINVERT_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORSELECTINVERT_TOOLTIP~
	ButtonText:~PARAMCOLLECTORSELECTINVERT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.selectInvert() )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnyParameters())	
)

macroScript ParamCollectorShowTBKeys
	category:~PARAMCOLLECTORSHOWTBKEYS_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORSHOWTBKEYS_TOOLTIP~
	ButtonText:~PARAMCOLLECTORSHOWTBKEYS_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( 
			if ParamCollectorOps.hideOtherKeys then (
				ParamCollectorOps.showTrackBarKeys = true
				ParamCollectorOps.hideOtherKeys = false
			)
			else (
				ParamCollectorOps.showTrackBarKeys = not ParamCollectorOps.showTrackBarKeys 
			)
		)
		Catch() 
	)

	on isChecked return (ParamCollectorOps.showTrackBarKeys and (not ParamCollectorOps.hideOtherKeys))
)

macroScript ParamCollectorShowTBSelectedKeys
	category:~PARAMCOLLECTORSHOWTBSELECTEDKEYS_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORSHOWTBSELECTEDKEYS_TOOLTIP~
	ButtonText:~PARAMCOLLECTORSHOWTBSELECTEDKEYS_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( 
			if ParamCollectorOps.hideOtherKeys then (
				ParamCollectorOps.showTrackBarSelectedKeys = true
				ParamCollectorOps.hideOtherKeys = false
			)
			else (
				ParamCollectorOps.showTrackBarSelectedKeys = not ParamCollectorOps.showTrackBarSelectedKeys 
			)
		)
		Catch() 
	)

	on isChecked return (ParamCollectorOps.showTrackBarSelectedKeys and (not ParamCollectorOps.hideOtherKeys))
)

macroScript ParamCollectorIsolateTBKeys
	category:~PARAMCOLLECTORISOLATETBKEYS_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORISOLATETBKEYS_TOOLTIP~
	ButtonText:~PARAMCOLLECTORISOLATETBKEYS_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( 
			if not ParamCollectorOps.hideOtherKeys then (
				ParamCollectorOps.showTrackBarKeys = true
				ParamCollectorOps.hideOtherKeys = true
			)
			else (
				ParamCollectorOps.showTrackBarKeys = not ParamCollectorOps.showTrackBarKeys 
			)
		)
		Catch() 
	)

	on isChecked return (ParamCollectorOps.showTrackBarKeys and ParamCollectorOps.hideOtherKeys)
)

macroScript ParamCollectorIsolateTBSelectedKeys
	category:~PARAMCOLLECTORISOLATETBSELECTEDKEYS_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORISOLATETBSELECTEDKEYS_TOOLTIP~
	ButtonText:~PARAMCOLLECTORISOLATETBSELECTEDKEYS_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( 
			if not ParamCollectorOps.hideOtherKeys then (
				ParamCollectorOps.showTrackBarSelectedKeys = true
				ParamCollectorOps.hideOtherKeys = true
			)
			else (
				ParamCollectorOps.showTrackBarSelectedKeys = not ParamCollectorOps.showTrackBarSelectedKeys 
			)
		)
		Catch() 
	)

	on isChecked return (ParamCollectorOps.showTrackBarSelectedKeys and ParamCollectorOps.hideOtherKeys)
)

macroScript ParamCollectorEditNotes
	category:~PARAMCOLLECTOREDITNOTES_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTOREDITNOTES_TOOLTIP~
	ButtonText:~PARAMCOLLECTOREDITNOTES_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.doEditNotesDialog() )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)

macroScript ParamCollectorKeyAll
	category:~PARAMCOLLECTORKEYALL_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORKEYALL_TOOLTIP~
	ButtonText:~PARAMCOLLECTORKEYALL_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.keyParameters false )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnyParameters() and animButtonState)
)

macroScript ParamCollectorKeySelected
	category:~PARAMCOLLECTORKEYSELECTED_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORKEYSELECTED_TOOLTIP~
	ButtonText:~PARAMCOLLECTORKEYSELECTED_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.keyParameters true )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected() and animButtonState)
)

macroScript ParamCollectorResetAll
	category:~PARAMCOLLECTORRESETALL_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORRESETALL_TOOLTIP~
	ButtonText:~PARAMCOLLECTORRESETALL_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.resetParameters false )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnyParameters())
)

macroScript ParamCollectorResetSelected
	category:~PARAMCOLLECTORRESETSELECTED_CATEGORY~ 
	internalCategory:"Parameter Collector" 
	tooltip:~PARAMCOLLECTORRESETSELECTED_TOOLTIP~
	ButtonText:~PARAMCOLLECTORRESETSELECTED_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ParamCollectorOps.resetParameters true )
		Catch() 
	)
	On isEnabled return (ParamCollectorOps.AnySelected())
)

